!
! To compile on Alpha machine:
!    f90 -free -cpp -convert big_endian read_veg_frac.F
! To complie on Linux:
!    pgf90 -Mfreeform -DRECLENBYPTE -byteswapio read_veg_frac.F
!
program read_vegetation

! Open direct access file SOILTEMP.60, and read it
!    Note that the deep soil temperature data starts at 
!         latitude 89.5 and longitude -179.5
!
!    - the file is in direct access format
!    - each direct access record contains data in one latitude circle
!      beginning at -179.5 degree longitude, and end at +179.5 degree
!    - the data is arranged to start at northernmost latitude (north pole),
!      and end at south pole

 implicit none
 integer:: nn,k

! declare variables

 integer :: iunit = 10
! rres is the number of data points in one degree lat/long
!      for 60 min data, that is 1
 integer :: rres  = 1
 integer :: rec_len_lat = 360*1 
 integer :: rec_len_lon = 180*1 
 integer :: rec_len, length, irec, jrec, nrec, ierr, nn
 integer :: begin_lat_rec, end_lat_rec, begin_lon_rec, end_lon_rec
 real    :: begin_lat, end_lat, begin_lon, end_lon

 real    :: tmax, tmin
 integer*2, dimension (360) :: soil_int
 real,dimension (360,180) :: soilt

! get the file name from input

! area of data to be printed
! longitudes are bounded between -180 W to +180 E

! record length for the data
!    each record has 360 data point, and each 2-byte is
!    used to represent a value for soil T

 rec_len = rec_len_lat
 length  = rec_len/2

#ifdef RECLENBYTE                                
! modify for machines like Cray, Sun, HP, IBM and Linux
 length = length*4                      
#endif                                         

! open 60 minute deep soil temperature data file: 

 open (iunit,file='SOILTEMP.60',access='DIRECT',recl=length,status='OLD')

! begin_record and end_record may be calculated as follows:
!
! nrec: from north to south (max 1080)
! irec: from west to east   (max 2160)

 tmin = 300.
 tmax = 280.

do nrec = 1, 180
    read (iunit, rec=nrec) soil_int 
    do nn = 1, 360
       soilt(nn,nrec) = float(soil_int(nn))/100.
       if (soilt(nn,nrec) .gt. tmax) tmax = soilt(nn,nrec)
       if (soilt(nn,nrec).lt.tmin.and.soilt(nn,nrec).ne.0.0) &
       tmin=soilt(nn,nrec)
    end do
 end do

 print *, 'tmax, tmin = ', tmax, tmin
 print *, 'lat=90, lon = ', (soilt(k,1),k=1,360)
 print *, 'lat=60, lon = ', (soilt(k,30),k=1,360)
 print *, 'lat=-90, lon = ', (soilt(k,180),k=1,360)

   do j=1, 180
      print*,' j='j, (soilt(i,j),i=1,360)
   enddo

 stop
end program read_vegetation

